/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL32C;

public class ClothRenderer {
    private MainRenderer mainRenderer;
    private double lastRenderPercent;
    private class_4587 tmpStack = new class_4587();

    public ClothRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(class_638 level, class_1921 blockLayerIn, double xIn, double yIn, double zInm, Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        int i;
        if (level == null) {
            return;
        }
        if (StarterClient.optifabric && PhysicsMod.optifineClothCompat.size() > 0) {
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.disableCull();
            for (i = 0; i < PhysicsMod.optifineClothCompat.size(); ++i) {
                PhysicsMod.optifineClothCompat.get(i).renderSlow((class_1937)level);
            }
            PhysicsMod.optifineClothCompat.clear();
            RenderSystem.enableBlend();
        }
        PerformanceTracker.startNoFlush("cloth_rendering");
        blockLayerIn.method_23516();
        this.mainRenderer.bindProperShader();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (class_8251)RenderSystem.getVertexSorting());
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_310.method_1551().field_1773.method_22974().method_3316();
        RenderSystem.activeTexture((int)33984);
        this.mainRenderer.resetColor();
        this.mainRenderer.setupShader(RenderSystem.getShader());
        VAO.storePreviouslyBoundState();
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL32C.glVertexAttribI2ui((int)Data.OVERLAY.getAttribute(), (int)0, (int)10);
        GL32C.glVertexAttrib4f((int)Data.COLOR.getAttribute(), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_SHADER.getAttribute(), (float)0.0f, (float)0.0f);
        }
        for (i = 0; i < PhysicsMod.clothRenderFast.size(); ++i) {
            ClothRenderCommand renderCommand = PhysicsMod.clothRenderFast.get(i);
            this.renderFast(level, renderCommand);
        }
        PhysicsMod.clothRenderFast.clear();
        VAO.restorePreviouslyBoundState();
        RenderSystem.getShader().method_34585();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableCull();
        blockLayerIn.method_23518();
        RenderSystem.applyModelViewMatrix();
        class_286.method_34420();
        PerformanceTracker.end("cloth_rendering");
    }

    private void renderFast(class_638 level, ClothRenderCommand renderCommand) {
        GL32C.glVertexAttribI2ui((int)Data.LIGHT.getAttribute(), (int)(renderCommand.brightness & 0xF0), (int)(renderCommand.brightness >> 16 & 0xF0));
        class_243 view = class_310.method_1551().field_1773.method_19418().method_19326();
        double renderPercent = class_310.method_1551().method_60646().method_60637(true);
        if (class_310.method_1551().method_1493()) {
            renderPercent = this.lastRenderPercent;
        } else {
            this.lastRenderPercent = renderPercent;
        }
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        class_5944 shader = RenderSystem.getShader();
        matrixStack.pushMatrix();
        int glID = renderCommand.textureID;
        RenderSystem.activeTexture((int)33984);
        RenderSystem.setShaderTexture((int)0, (int)glID);
        RenderSystem.bindTexture((int)glID);
        class_1309 entity = renderCommand.entity;
        double px = class_3532.method_16436((double)renderPercent, (double)entity.field_6038, (double)entity.method_23317());
        double py = class_3532.method_16436((double)renderPercent, (double)entity.field_5971, (double)entity.method_23318());
        double pz = class_3532.method_16436((double)renderPercent, (double)entity.field_5989, (double)entity.method_23321());
        matrixStack.translation((float)(-view.field_1352 + px), (float)(-view.field_1351 + py), (float)(-view.field_1350 + pz));
        renderCommand.modelPart.method_32085(renderCommand.modelPose);
        this.tmpStack.method_23760().method_23761().set((Matrix4fc)matrixStack);
        ModelPartConstraint.entityTransformation(this.tmpStack, entity, (float)renderPercent);
        ModelPartConstraint.modelPartTransformation(renderCommand.modelPart, this.tmpStack);
        Matrix4f transformation = this.tmpStack.method_23760().method_23761();
        this.mainRenderer.setupLighting(transformation, shader, level, true);
        PhysicsMod.viewMatrix.mul((Matrix4fc)transformation, transformation);
        this.mainRenderer.setupModelViewMatrix(shader, transformation, null, true);
        this.mainRenderer.setupPBRTextures();
        this.mainRenderer.setupShaderUniforms(shader);
        if (!renderCommand.onlyRenderPlayer) {
            if (ConfigClient.clothSmoothShading) {
                renderCommand.cloth.vao.render();
            } else {
                renderCommand.cloth.vaoFlatShaded.render();
            }
        }
        if (renderCommand.cloth.playerVAO != null && entity instanceof class_742) {
            class_742 player = (class_742)entity;
            glID = class_310.method_1551().method_1531().method_4619(player.method_52814().comp_1626()).method_4624();
            RenderSystem.setShaderTexture((int)0, (int)glID);
            RenderSystem.bindTexture((int)glID);
            this.mainRenderer.setupPBRTextures();
            renderCommand.cloth.playerVAO.render();
        }
        matrixStack.popMatrix();
    }
}

